/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world;

import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.world.WorldGenMinableCluster;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenDecoration
extends WorldGenerator {
    private final List<WeightedRandomBlock> cluster;
    private final WeightedRandomBlock[] genBlock;
    private final WeightedRandomBlock[] onBlock;
    private final int clusterSize;
    public boolean seeSky = true;
    public boolean checkStay = true;
    public int stackHeight = 1;
    public int xVar = 8;
    public int yVar = 4;
    public int zVar = 8;

    public WorldGenDecoration(List<WeightedRandomBlock> list, int n, List<WeightedRandomBlock> list2, List<WeightedRandomBlock> list3) {
        this.cluster = list;
        this.clusterSize = n;
        this.genBlock = list2 == null ? null : list2.toArray(new WeightedRandomBlock[list2.size()]);
        this.onBlock = list3 == null ? null : list3.toArray(new WeightedRandomBlock[list3.size()]);
    }

    public boolean generate(World world, Random random, int n, int n2, int n3) {
        boolean bl = false;
        int n4 = this.clusterSize;
        block0: while (n4-- > 0) {
            int n5;
            int n6;
            int n7;
            int n8 = n + random.nextInt(this.xVar) - random.nextInt(this.xVar);
            if (!world.blockExists(n8, n7 = n2 + (this.yVar > 1 ? random.nextInt(this.yVar) - random.nextInt(this.yVar) : 0), n6 = n3 + random.nextInt(this.zVar) - random.nextInt(this.zVar))) {
                ++n4;
                continue;
            }
            if (this.seeSky && !world.canBlockSeeTheSky(n8, n7, n6) || !WorldGenMinableCluster.canGenerateInBlock(world, n8, n7 - 1, n6, this.onBlock) || !WorldGenMinableCluster.canGenerateInBlock(world, n8, n7, n6, this.genBlock)) continue;
            WeightedRandomBlock weightedRandomBlock = WorldGenMinableCluster.selectBlock(world, this.cluster);
            int n9 = n5 = this.stackHeight > 1 ? random.nextInt(this.stackHeight) : 0;
            while (!this.checkStay || weightedRandomBlock.block.canBlockStay(world, n8, n7, n6)) {
                bl |= world.setBlock(n8, n7, n6, weightedRandomBlock.block, weightedRandomBlock.metadata, 2);
                if (WorldGenMinableCluster.canGenerateInBlock(world, n8, ++n7, n6, this.genBlock) && n5-- > 0) continue;
                continue block0;
            }
        }
        return bl;
    }
}

